<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        <div class="max-w-3xl mx-auto">
            
            <div class="flex items-center mb-6">
                <a href="<?php echo site_url('admin/pengguna'); ?>" class="text-slate-500 hover:text-cyan-600 mr-4">
                    <i class="fas fa-arrow-left fa-lg"></i>
                </a>
                <h1 class="text-3xl font-bold text-slate-800">
                    Edit Pengguna
                </h1>
            </div>

            <div class="bg-white shadow-xl rounded-2xl p-8">
                <form action="<?php echo site_url('admin/pengguna/update/' . $user['id']); ?>" method="post">
                    
                    <div class="flex items-center space-x-6 mb-8">
                        <div class="flex-shrink-0">
                             <?php 
                                $avatar_url_form = base_url('assets/img/default-avatar.png');
                                if (!empty($user['avatar'])) {
                                    $avatar_path_check_form = FCPATH . 'uploads/avatars/' . $user['avatar'];
                                    if (file_exists($avatar_path_check_form)) {
                                        $avatar_url_form = base_url('uploads/avatars/' . $user['avatar']);
                                    }
                                }
                            ?>
                            <img class="h-24 w-24 rounded-full object-cover" src="<?php echo $avatar_url_form; ?>" alt="Avatar">
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-slate-800"><?php echo html_escape($user['nama']); ?></h3>
                            <p class="text-slate-500"><?php echo html_escape($user['email']); ?></p>
                        </div>
                    </div>

                    <div class="border-b border-slate-200 pb-6 mb-6">
                        <h3 class="text-lg font-semibold text-slate-700 mb-4">Informasi Akun</h3>
                        <div>
                            <label for="nama" class="block text-sm font-medium text-slate-600 mb-1">Nama Lengkap</label>
                            <input type="text" name="nama" id="nama" value="<?php echo html_escape($user['nama']); ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" required>
                        </div>
                        <div class="mt-4">
                            <label for="email" class="block text-sm font-medium text-slate-600 mb-1">Alamat Email</label>
                            <input type="email" name="email" id="email" value="<?php echo html_escape($user['email']); ?>" class="w-full px-4 py-2 border border-slate-200 bg-slate-100 rounded-lg cursor-not-allowed" readonly>
                            <p class="text-xs text-slate-400 mt-1">Email tidak dapat diubah.</p>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-slate-700 mb-4">Hak Akses</h3>
                        <div>
                            <label for="role" class="block text-sm font-medium text-slate-600 mb-1">Role Pengguna</label>
                            <select name="role" id="role" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" <?php if($this->session->userdata('user_id') == $user['id']) echo 'disabled'; ?>>
                                <option value="user" <?php if($user['role'] == 'user') echo 'selected'; ?>>User</option>
                                <option value="admin" <?php if($user['role'] == 'admin') echo 'selected'; ?>>Administrator</option>
                            </select>
                             <?php if($this->session->userdata('user_id') == $user['id']): ?>
                                <p class="text-xs text-red-500 mt-1">Anda tidak dapat mengubah role akun Anda sendiri.</p>
                            <?php endif; ?>
                        </div>
                    </div>

                     <div class="mt-6 p-4 bg-yellow-50 border-l-4 border-yellow-400 text-yellow-700 rounded-r-lg">
                        <p class="font-bold">Keamanan Password</p>
                        <p class="text-sm">Perubahan password tidak dilakukan di sini. Pengguna harus menggunakan fitur "Lupa Password" untuk keamanan.</p>
                    </div>

                    <div class="flex justify-end space-x-4 mt-8 pt-6 border-t border-slate-200">
                        <a href="<?php echo site_url('admin/pengguna'); ?>" class="bg-slate-200 hover:bg-slate-300 text-slate-800 font-bold py-2.5 px-6 rounded-lg transition-colors">
                            Batal
                        </a>
                        <button type="submit" class="bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-2.5 px-6 rounded-lg transition-colors shadow-md hover:shadow-lg">
                            Simpan Perubahan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>