<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        <div class="max-w-3xl mx-auto">
            
            <div class="flex items-center mb-6">
                <a href="<?php echo site_url('admin/rute'); ?>" class="text-slate-500 hover:text-cyan-600 mr-4">
                    <i class="fas fa-arrow-left fa-lg"></i>
                </a>
                <h1 class="text-3xl font-bold text-slate-800">
                    <?php echo isset($rute) ? 'Edit Rute' : 'Tambah Rute Baru'; ?>
                </h1>
            </div>

            <div class="bg-white shadow-xl rounded-2xl p-8">
                <form action="<?php echo isset($rute) ? site_url('admin/rute/update/' . $rute['id']) : site_url('admin/rute/simpan'); ?>" method="post">
                    
                    <div class="border-b border-slate-200 pb-6 mb-6">
                        <h3 class="text-lg font-semibold text-slate-700 mb-4">Informasi Perjalanan</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="asal" class="block text-sm font-medium text-slate-600 mb-1">Kota Asal</label>
                                <input type="text" name="asal" id="asal" value="<?php echo isset($rute) ? html_escape($rute['asal']) : ''; ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" required>
                            </div>
                            <div>
                                <label for="tujuan" class="block text-sm font-medium text-slate-600 mb-1">Kota Tujuan</label>
                                <input type="text" name="tujuan" id="tujuan" value="<?php echo isset($rute) ? html_escape($rute['tujuan']) : ''; ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" required>
                            </div>
                        </div>
                    </div>

                    <div class="border-b border-slate-200 pb-6 mb-6">
                        <h3 class="text-lg font-semibold text-slate-700 mb-4">Jadwal & Armada</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="tanggal_berangkat" class="block text-sm font-medium text-slate-600 mb-1">Tanggal Berangkat</label>
                                <input type="date" name="tanggal_berangkat" id="tanggal_berangkat" value="<?php echo isset($rute) ? $rute['tanggal_berangkat'] : ''; ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" required>
                            </div>
                            <div>
                                <label for="jam_berangkat" class="block text-sm font-medium text-slate-600 mb-1">Jam Berangkat</label>
                                <input type="time" name="jam_berangkat" id="jam_berangkat" value="<?php echo isset($rute) ? $rute['jam_berangkat'] : ''; ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" required>
                            </div>
                        </div>
                        <div class="mt-6">
                            <label for="bus_id" class="block text-sm font-medium text-slate-600 mb-1">Pilih Bus</label>
                            <select name="bus_id" id="bus_id" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" required>
                                <option value="" disabled selected>-- Pilih Armada Bus --</option>
                                <?php foreach ($buses as $bus): ?>
                                    <option value="<?php echo $bus['id']; ?>" <?php if(isset($rute) && $rute['bus_id'] == $bus['id']) echo 'selected'; ?>>
                                        <?php echo html_escape($bus['tipe_bus']); ?> (Kapasitas: <?php echo $bus['kapasitas']; ?>)
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-slate-700 mb-4">Harga</h3>
                        <div>
                            <label for="harga" class="block text-sm font-medium text-slate-600 mb-1">Harga Tiket (Rp)</label>
                            <input type="number" name="harga" id="harga" value="<?php echo isset($rute) ? $rute['harga'] : ''; ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" placeholder="Contoh: 150000" required>
                        </div>
                    </div>

                    <div class="flex justify-end space-x-4 mt-8 pt-6 border-t border-slate-200">
                        <a href="<?php echo site_url('admin/rute'); ?>" class="bg-slate-200 hover:bg-slate-300 text-slate-800 font-bold py-2.5 px-6 rounded-lg transition-colors">
                            Batal
                        </a>
                        <button type="submit" class="bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-2.5 px-6 rounded-lg transition-colors shadow-md hover:shadow-lg">
                            Simpan Rute
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>