<?php if (!empty($bookings_data)): ?>
    <?php foreach ($bookings_data as $pesanan): ?>
        <tr class="border-b border-slate-100 hover:bg-slate-50 transition-colors duration-200">
            <td class="py-4 px-6">
                <div class="flex items-center">
                    <div class="flex-shrink-0 h-10 w-10 flex items-center justify-center bg-slate-200 rounded-full text-slate-600">
                        <i class="fas fa-user"></i>
                    </div>
                    <div class="ml-4">
                        <div class="font-semibold text-slate-800"><?php echo html_escape($pesanan['nama']); ?></div>
                        <div class="text-xs text-slate-500">ID Pesanan: <?php echo html_escape($pesanan['id']); ?></div>
                    </div>
                </div>
            </td>
            <td class="py-4 px-6">
                <div class="font-medium text-slate-800"><?php echo html_escape($pesanan['rute_asal']); ?> &rarr; <?php echo html_escape($pesanan['rute_tujuan']); ?></div>
                <div class="text-sm text-slate-500">Keberangkatan <?php echo date('d M Y', strtotime($pesanan['tanggal_berangkat'])); ?></div>
            </td>
            <td class="py-4 px-6 text-sm text-slate-600">
                <?php echo date('d M Y, H:i', strtotime($pesanan['created_at'])); ?>
            </td>
            <td class="py-4 px-6 text-center">
                <?php if ($pesanan['status_pembayaran'] == 'paid'): ?>
                    <span class="bg-green-100 text-green-800 font-medium text-xs px-3 py-1 rounded-full">Paid</span>
                <?php elseif ($pesanan['status_pembayaran'] == 'pending'): ?>
                    <span class="bg-yellow-100 text-yellow-800 font-medium text-xs px-3 py-1 rounded-full">Pending</span>
                <?php else: ?>
                    <span class="bg-red-100 text-red-800 font-medium text-xs px-3 py-1 rounded-full">Cancelled</span>
                <?php endif; ?>
            </td>
            <td class="py-4 px-6 text-center">
                <a href="<?php echo site_url('admin/pesanan/detail/' . $pesanan['id']); ?>" class="bg-cyan-500 text-white font-bold py-2 px-4 rounded-lg hover:bg-cyan-600 transition duration-300 text-sm">
                    Lihat Detail
                </a>
            </td>
        </tr>
    <?php endforeach; ?>
<?php else: ?>
     <tr>
        <td colspan="5" class="py-10 px-6 text-center text-slate-500">
            <i class="fas fa-search fa-3x mb-3"></i>
            <p>Data tidak ditemukan.</p>
        </td>
    </tr>
<?php endif; ?>