<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8">
            <div>
                <h1 class="text-3xl font-bold text-slate-800">Manajemen Pengguna</h1>
                <p class="text-slate-500 mt-1">Kelola semua akun pengguna dan administrator.</p>
            </div>
        </div>

        <?php if ($this->session->flashdata('success')): ?>
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded-r-lg" role="alert">
                <p><?php echo $this->session->flashdata('success'); ?></p>
            </div>
        <?php endif; ?>
        <?php if ($this->session->flashdata('error')): ?>
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-r-lg" role="alert">
                <p><?php echo $this->session->flashdata('error'); ?></p>
            </div>
        <?php endif; ?>

        <div class="bg-white shadow-xl rounded-2xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-slate-100">
                        <tr>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Nama Pengguna</th>
                            <th class="py-3 px-6 text-center text-sm font-semibold text-slate-600">Role</th>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Tanggal Bergabung</th>
                            <th class="py-3 px-6 text-center text-sm font-semibold text-slate-600">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-slate-700">
                        <?php if (!empty($users_data)): ?>
                            <?php foreach ($users_data as $user): ?>
                                <tr class="border-b border-slate-100 hover:bg-slate-50 transition-colors duration-200">
                                    <td class="py-3 px-6">
                                        <div class="flex items-center">
                                            <div class="flex-shrink-0 h-11 w-11">
                                                <?php 
                                                    $avatar_url = base_url('assets/img/default-avatar.png');
                                                    if (!empty($user['avatar'])) {
                                                        $avatar_path_check = FCPATH . 'uploads/avatars/' . $user['avatar'];
                                                        if (file_exists($avatar_path_check)) {
                                                            $avatar_url = base_url('uploads/avatars/' . $user['avatar']);
                                                        }
                                                    }
                                                ?>
                                                <img class="h-11 w-11 rounded-full object-cover" src="<?php echo $avatar_url; ?>" alt="Avatar">
                                            </div>
                                            <div class="ml-4">
                                                <div class="font-semibold text-slate-800"><?php echo html_escape($user['nama']); ?></div>
                                                <div class="text-sm text-slate-500"><?php echo html_escape($user['email']); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-4 px-6 text-center">
                                        <?php if ($user['role'] == 'admin'): ?>
                                            <span class="bg-purple-100 text-purple-800 font-medium text-xs px-3 py-1 rounded-full">Administrator</span>
                                        <?php else: ?>
                                            <span class="bg-slate-100 text-slate-800 font-medium text-xs px-3 py-1 rounded-full">User</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="py-4 px-6 text-sm text-slate-600">
                                        <?php echo date('d M Y', strtotime($user['created_at'])); ?>
                                    </td>
                                    <td class="py-4 px-6 text-center">
                                        <a href="<?php echo site_url('admin/pengguna/edit/' . $user['id']); ?>" class="text-slate-500 hover:text-cyan-600 mr-4" title="Edit">
                                            <i class="fas fa-pencil-alt fa-lg"></i>
                                        </a>
                                        <?php if($this->session->userdata('user_id') != $user['id']): ?>
                                            <button data-id="<?php echo $user['id']; ?>" class="delete-btn text-slate-500 hover:text-red-600" title="Hapus">
                                                <i class="fas fa-trash-alt fa-lg"></i>
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="4" class="py-10 px-6 text-center text-slate-500">
                                    <i class="fas fa-users-slash fa-3x mb-3"></i>
                                    <p>Data pengguna belum tersedia.</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="bg-white border-t border-slate-100">
                <?php echo $pagination; ?>
            </div>
        </div>
    </div>
</div>

<div id="deleteConfirmModal" class="hidden fixed inset-0 bg-gray-900 bg-opacity-60 flex items-center justify-center z-[1000] p-4">
    <div id="deleteModalContent" class="bg-white rounded-xl shadow-xl p-6 sm:p-8 text-center max-w-sm w-full transition-all duration-300 ease-out transform scale-95 opacity-0">
        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-red-100 mb-4">
            <svg class="h-10 w-10 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path></svg>
        </div>
        <h3 class="text-2xl font-bold font-display mb-2 text-gray-800">Konfirmasi Penghapusan</h3>
        <p class="mb-6 text-gray-600 font-sans">Apakah Anda yakin ingin menghapus pengguna ini? Tindakan ini tidak dapat dibatalkan.</p>
        <div class="flex justify-center space-x-4">
            <button id="cancelDeleteBtn" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-bold py-2.5 px-6 rounded-lg transition-colors">
                Batal
            </button>
            <a id="confirmDeleteBtn" href="#" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2.5 px-6 rounded-lg transition-colors">
                Ya, Hapus
            </a>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Mendapatkan referensi elemen modal
    // Memeriksa keberadaan elemen sebelum menggunakannya
    const deleteModal = document.getElementById('deleteConfirmModal');
    const deleteModalContent = document.getElementById('deleteModalContent');
    const cancelDeleteBtn = document.getElementById('cancelDeleteBtn');
    const confirmDeleteBtn = document.getElementById('confirmDeleteBtn');
    const deleteButtons = document.querySelectorAll('.delete-btn'); // Ini akan bekerja meski tanpa modal, tapi event listener tidak akan terpanggil

    // Pastikan modal dan tombol-tombolnya ditemukan sebelum menambahkan event listener
    if (deleteModal && deleteModalContent && cancelDeleteBtn && confirmDeleteBtn) {
        // Iterasi setiap tombol delete dan tambahkan event listener
        deleteButtons.forEach(button => {
            button.addEventListener('click', function() {
                // Mengambil ID pengguna dari atribut data-id pada tombol yang diklik
                // Menggunakan .dataset.id karena kita menambahkannya di PHP
                const userId = this.dataset.id;
                // Membangun URL hapus menggunakan ID pengguna
                const deleteUrl = `<?php echo site_url('admin/pengguna/hapus/'); ?>${userId}`;
                
                // Mengatur atribut href pada tombol konfirmasi modal
                confirmDeleteBtn.setAttribute('href', deleteUrl);
                
                // Menampilkan modal (menghapus kelas 'hidden')
                deleteModal.classList.remove('hidden');
                
                // Memicu animasi transisi modal masuk setelah jeda singkat
                setTimeout(() => {
                    deleteModalContent.classList.remove('scale-95', 'opacity-0');
                    deleteModalContent.classList.add('scale-100', 'opacity-100');
                }, 50); // Jeda 50ms agar browser sempat me-render sebelum animasi
            });
        });

        // Fungsi untuk menutup modal dengan animasi
        function closeModal() {
            deleteModalContent.classList.add('scale-95', 'opacity-0'); // Memulai animasi keluar
            setTimeout(() => {
                deleteModal.classList.add('hidden'); // Menyembunyikan modal setelah animasi selesai
            }, 300); // Durasi ini harus sesuai dengan durasi transisi CSS
        }

        // Event listener untuk tombol 'Batal' di dalam modal
        cancelDeleteBtn.addEventListener('click', closeModal);
        
        // Event listener untuk menutup modal jika mengklik di luar area konten modal
        deleteModal.addEventListener('click', function(e) {
            if (e.target === deleteModal) {
                closeModal();
            }
        });
    } else {
        console.warn("HTML elemen modal delete tidak ditemukan. Pastikan ID cocok dan elemen ada di DOM.");
    }
});
</script>