<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        
        <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-8">
            <div>
                <h1 class="text-3xl font-bold text-slate-800">Manajemen Rute</h1>
                <p class="text-slate-500 mt-1">Kelola semua jadwal keberangkatan bus.</p>
            </div>
            <a href="<?php echo site_url('admin/rute/tambah'); ?>" class="mt-4 sm:mt-0 bg-cyan-500 text-white font-bold py-2 px-4 rounded-lg hover:bg-cyan-600 transition duration-300 shadow-md hover:shadow-lg flex items-center">
                <i class="fas fa-plus mr-2"></i> Tambah Rute Baru
            </a>
        </div>

        <?php if ($this->session->flashdata('success')): ?>
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded-r-lg" role="alert">
                <p class="font-bold">Sukses</p>
                <p><?php echo $this->session->flashdata('success'); ?></p>
            </div>
        <?php endif; ?>

        <div class="bg-white shadow-xl rounded-2xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-slate-100">
                        <tr>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Rute & Bus</th>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Jadwal</th>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Harga</th>
                            <th class="py-3 px-6 text-center text-sm font-semibold text-slate-600">Status</th>
                            <th class="py-3 px-6 text-center text-sm font-semibold text-slate-600">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-slate-700">
                        <?php if (!empty($routes_data)): ?>
                            <?php foreach ($routes_data as $rute): ?>
                                <tr class="border-b border-slate-100 hover:bg-slate-50 transition-colors duration-200">
                                    <td class="py-4 px-6">
                                        <div class="flex items-center">
                                            <div class="flex-shrink-0 h-12 w-12 flex items-center justify-center bg-purple-100 rounded-full text-purple-600 font-bold">
                                                <i class="fas fa-route"></i>
                                            </div>
                                            <div class="ml-4">
                                                <div class="font-semibold text-slate-800"><?php echo html_escape($rute['asal']); ?> &rarr; <?php echo html_escape($rute['tujuan']); ?></div>
                                                <div class="text-sm text-slate-500"><?php echo html_escape($rute['tipe_bus']); ?></div>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-4 px-6">
                                        <div class="font-medium text-slate-800"><?php echo date('d M Y', strtotime($rute['tanggal_berangkat'])); ?></div>
                                        <div class="text-sm text-slate-500"><?php echo html_escape($rute['jam_berangkat']); ?> WIB</div>
                                    </td>
                                    <td class="py-4 px-6 font-semibold text-slate-800">
                                        Rp <?php echo number_format($rute['harga'], 0, ',', '.'); ?>
                                    </td>
                                    <td class="py-4 px-6 text-center">
                                        <span class="bg-green-100 text-green-800 text-xs font-semibold px-3 py-1 rounded-full">Aktif</span>
                                    </td>
                                    <td class="py-4 px-6 text-center">
                                        <a href="<?php echo site_url('admin/rute/edit/' . $rute['id']); ?>" class="text-slate-500 hover:text-cyan-600 mr-4" title="Edit">
                                            <i class="fas fa-pencil-alt fa-lg"></i>
                                        </a>
                                        <button data-id="<?php echo $rute['id']; ?>" class="text-slate-500 hover:text-red-600 delete-btn" title="Hapus">
                                            <i class="fas fa-trash-alt fa-lg"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5" class="py-10 px-6 text-center text-slate-500">
                                    <i class="fas fa-box-open fa-3x mb-3"></i>
                                    <p>Data rute belum tersedia.</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="bg-white border-t border-slate-100">
                <?php echo $pagination; ?>
            </div>
        </div>
    </div>
</div>

<div id="deleteConfirmModal" class="hidden fixed inset-0 bg-gray-900 bg-opacity-60 flex items-center justify-center z-[1000] p-4">
    <div class="bg-white rounded-2xl shadow-xl p-8 text-center max-w-sm w-full transform transition-all duration-300 scale-95 opacity-0" id="deleteModalContent">
        <div class="flex items-center justify-center h-16 w-16 rounded-full bg-red-100 mx-auto mb-4">
            <i class="fas fa-exclamation-triangle fa-2x text-red-600"></i>
        </div>
        <h3 class="text-2xl font-bold mb-2 text-slate-800">Anda Yakin?</h3>
        <p class="mb-6 text-slate-500">Data yang sudah dihapus tidak dapat dikembalikan lagi. Lanjutkan?</p>
        <div class="flex justify-center space-x-4">
            <button id="cancelDeleteBtn" class="bg-slate-200 hover:bg-slate-300 text-slate-800 font-bold py-2.5 px-6 rounded-lg transition-colors">
                Batal
            </button>
            <a id="confirmDeleteBtn" href="#" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2.5 px-6 rounded-lg transition-colors">
                Ya, Hapus
            </a>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const deleteModal = document.getElementById('deleteConfirmModal');
    const deleteModalContent = document.getElementById('deleteModalContent');
    const cancelDeleteBtn = document.getElementById('cancelDeleteBtn');
    const confirmDeleteBtn = document.getElementById('confirmDeleteBtn');
    const deleteButtons = document.querySelectorAll('.delete-btn');

    deleteButtons.forEach(button => {
        button.addEventListener('click', function() {
            const ruteId = this.dataset.id;
            const deleteUrl = `<?php echo site_url('admin/rute/hapus/'); ?>${ruteId}`;
            confirmDeleteBtn.setAttribute('href', deleteUrl);
            
            deleteModal.classList.remove('hidden');
            // Memicu animasi
            setTimeout(() => {
                deleteModalContent.classList.remove('scale-95', 'opacity-0');
                deleteModalContent.classList.add('scale-100', 'opacity-100');
            }, 50);
        });
    });

    function closeModal() {
        deleteModalContent.classList.add('scale-95', 'opacity-0');
        setTimeout(() => {
            deleteModal.classList.add('hidden');
        }, 300); // Sesuaikan dengan durasi transisi
    }

    cancelDeleteBtn.addEventListener('click', closeModal);
    deleteModal.addEventListener('click', function(e) {
        if (e.target === deleteModal) {
            closeModal();
        }
    });
});
</script>