<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        
        <div class="flex justify-between items-center mb-6">
            <div>
                <h1 class="text-3xl font-bold text-slate-800">Manajemen Pesanan</h1>
                <p class="text-slate-500 mt-1">Pantau dan verifikasi semua transaksi.</p>
            </div>
        </div>

        <div class="bg-white p-4 rounded-xl shadow-lg border border-slate-100 mb-6">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 items-center">
                
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-search text-slate-400"></i>
                    </div>
                    <input type="text" id="searchInput" placeholder="Cari pesanan, nama, atau rute..." class="w-full block pl-10 pr-3 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-400 focus:border-cyan-400 transition">
                </div>

                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-calendar-alt text-slate-400"></i>
                    </div>
                    <input type="text" id="dateInput" placeholder="Tanggal Berangkat" class="w-full block pl-10 pr-3 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-400 focus:border-cyan-400 transition">
                </div>

                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-tag text-slate-400"></i>
                    </div>
                    <select id="statusFilter" class="w-full block appearance-none pl-10 pr-8 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-400 focus:border-cyan-400 transition">
                        <option value="">Semua Status</option>
                        <option value="paid">Paid</option>
                        <option value="pending">Pending</option>
                        <option value="cancelled">Cancelled</option>
                    </select>
                    <div class="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                        <i class="fas fa-chevron-down text-slate-400 text-xs"></i>
                    </div>
                </div>

                <button id="resetFilterBtn" class="w-full bg-slate-200 text-slate-700 font-semibold py-2 px-4 rounded-lg hover:bg-slate-300 transition flex items-center justify-center">
                    <i class="fas fa-times mr-2 text-sm"></i>
                    Reset Filter
                </button>

            </div>
        </div>

        <div class="bg-white shadow-xl rounded-2xl overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-slate-100">
                        <tr>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Pelanggan</th>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Detail Perjalanan</th>
                            <th class="py-3 px-6 text-left text-sm font-semibold text-slate-600">Tanggal Pesan</th>
                            <th class="py-3 px-6 text-center text-sm font-semibold text-slate-600">Status</th>
                            <th class="py-3 px-6 text-center text-sm font-semibold text-slate-600">Aksi</th>
                        </tr>
                    </thead>
                    <tbody id="bookingTableBody" class="text-slate-700">
                        <?php $this->load->view('admin/partials/booking_table_partial', ['bookings_data' => $bookings_data]); ?>
                    </tbody>
                </table>
            </div>
            <div id="paginationLinks" class="bg-white border-t border-slate-100">
                <?php echo $pagination; ?>
            </div>
        </div>
    </div>
</div>