<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-3xl font-bold text-slate-800">Admin Dashboard</h1>
                <p class="text-slate-500 mt-1">Selamat datang kembali, <?php echo html_escape($this->session->userdata('user_nama')); ?>!</p>
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            
            <div class="lg:col-span-2 space-y-8">
                
                <div class="grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-4 gap-6">

                    <div class="bg-white p-6 rounded-2xl shadow-lg border border-slate-100">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="text-base font-medium text-slate-500">Total Pendapatan</p>
                                <p class="text-3xl font-bold text-slate-800 mt-1">Rp <?php echo number_format($stats['total_pendapatan'], 0, ',', '.'); ?></p>
                            </div>
                            <div class="bg-green-100 text-green-600 p-3 rounded-full">
                                <i class="fas fa-wallet fa-lg"></i>
                            </div>
                        </div>
                        <p class="text-xs text-green-500 mt-4 flex items-center">
                            <i class="fas fa-arrow-up mr-1"></i>
                            <span>Lunas terverifikasi</span>
                        </p>
                    </div>

                    <div class="bg-white p-6 rounded-2xl shadow-lg border border-slate-100">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="text-base font-medium text-slate-500">Tiket Terjual</p>
                                <p class="text-3xl font-bold text-slate-800 mt-1"><?php echo number_format($stats['total_tiket_terjual']); ?></p>
                            </div>
                            <div class="bg-blue-100 text-blue-600 p-3 rounded-full">
                                <i class="fas fa-ticket-alt fa-lg"></i>
                            </div>
                        </div>
                        <p class="text-xs text-slate-400 mt-4">
                            Total dari pesanan lunas
                        </p>
                    </div>

                    <div class="bg-white p-6 rounded-2xl shadow-lg border border-slate-100">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="text-base font-medium text-slate-500">Jumlah Rute</p>
                                <p class="text-3xl font-bold text-slate-800 mt-1"><?php echo number_format($stats['total_rute']); ?></p>
                            </div>
                            <div class="bg-purple-100 text-purple-600 p-3 rounded-full">
                                <i class="fas fa-road fa-lg"></i>
                            </div>
                        </div>
                        <p class="text-xs text-slate-400 mt-4">
                            Rute aktif tersedia
                        </p>
                    </div>

                    <div class="bg-white p-6 rounded-2xl shadow-lg border border-slate-100">
                        <div class="flex justify-between items-start">
                            <div>
                                <p class="text-base font-medium text-slate-500">Total Pengguna</p>
                                <p class="text-3xl font-bold text-slate-800 mt-1"><?php echo number_format($stats['total_pengguna']); ?></p>
                            </div>
                            <div class="bg-orange-100 text-orange-600 p-3 rounded-full">
                                <i class="fas fa-users fa-lg"></i>
                            </div>
                        </div>
                        <p class="text-xs text-slate-400 mt-4">
                            Pengguna terdaftar
                        </p>
                    </div>

                </div>

                <div class="bg-white p-6 rounded-2xl shadow-lg border border-slate-100">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-semibold text-slate-800">Pendapatan 7 Hari Terakhir</h3>
                    </div>
                    <div class="h-80">
                        <canvas id="revenueChart"></canvas>
                    </div>
                </div>

            </div>
            
            <div class="lg:col-span-1 space-y-8">
                
                <div class="bg-white p-6 rounded-2xl shadow-lg border border-slate-100">
                    <h3 class="text-lg font-semibold text-slate-800 mb-4">Rute Terpopuler</h3>
                    <ul class="space-y-4">
                        <?php if (!empty($popular_routes_admin)): ?>
                            <?php foreach($popular_routes_admin as $route): ?>
                                <li>
                                    <div class="flex justify-between items-center text-sm mb-1">
                                        <span class="font-medium text-slate-700"><?php echo html_escape($route['asal']); ?> &rarr; <?php echo html_escape($route['tujuan']); ?></span>
                                        <span class="text-slate-500"><?php echo html_escape($route['jumlah_pesanan']); ?> tiket</span>
                                    </div>
                                    <div class="w-full bg-slate-200 rounded-full h-2">
                                        <div class="bg-cyan-500 h-2 rounded-full" style="width: <?php echo ($route['jumlah_pesanan'] / $stats['total_tiket_terjual']) * 100; ?>%"></div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <p class="text-sm text-slate-400 text-center">Belum ada data rute populer.</p>
                        <?php endif; ?>
                    </ul>
                </div>

                <div class="bg-white p-6 rounded-2xl shadow-lg border border-slate-100">
                     <h3 class="text-lg font-semibold text-slate-800 mb-4">Aktivitas Terbaru</h3>
                     <ul class="space-y-4">
                         <?php if (!empty($recent_activities)): ?>
                             <?php foreach($recent_activities as $activity): ?>
                                <li class="flex items-start">
                                    <div class="mr-3 mt-1">
                                        <?php if ($activity['type'] == 'pembayaran'): ?>
                                            <span class="flex h-8 w-8 items-center justify-center rounded-full bg-green-100 text-green-600"><i class="fas fa-check"></i></span>
                                        <?php else: ?>
                                            <span class="flex h-8 w-8 items-center justify-center rounded-full bg-blue-100 text-blue-600"><i class="fas fa-receipt"></i></span>
                                        <?php endif; ?>
                                    </div>
                                    <div>
                                        <p class="text-sm font-medium text-slate-700"><?php echo html_escape($activity['description']); ?></p>
                                        <p class="text-xs text-slate-400"><?php echo html_escape($activity['timestamp']); ?></p>
                                    </div>
                                </li>
                             <?php endforeach; ?>
                         <?php else: ?>
                             <p class="text-sm text-slate-400 text-center">Belum ada aktivitas terbaru.</p>
                         <?php endif; ?>
                     </ul>
                </div>

            </div>
        </div>
    </div>
</div>