<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        <div class="max-w-3xl mx-auto">
            
            <div class="flex items-center mb-6">
                <a href="<?php echo site_url('admin/bus'); ?>" class="text-slate-500 hover:text-cyan-600 mr-4">
                    <i class="fas fa-arrow-left fa-lg"></i>
                </a>
                <h1 class="text-3xl font-bold text-slate-800">
                    <?php echo isset($bus) ? 'Edit Bus' : 'Tambah Bus Baru'; ?>
                </h1>
            </div>

            <div class="bg-white shadow-xl rounded-2xl p-8">
                <form action="<?php echo isset($bus) ? site_url('admin/bus/update/' . $bus['id']) : site_url('admin/bus/simpan'); ?>" method="post">
                    
                    <div class="border-b border-slate-200 pb-6 mb-6">
                        <h3 class="text-lg font-semibold text-slate-700 mb-4">Informasi Armada</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="tipe_bus" class="block text-sm font-medium text-slate-600 mb-1">Tipe Bus</label>
                                <input type="text" name="tipe_bus" id="tipe_bus" value="<?php echo isset($bus) ? html_escape($bus['tipe_bus']) : ''; ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" placeholder="Contoh: Eksekutif, Patas AC" required>
                            </div>
                            <div>
                                <label for="kapasitas" class="block text-sm font-medium text-slate-600 mb-1">Kapasitas</small>
                                <input type="number" name="kapasitas" id="kapasitas" value="<?php echo isset($bus) ? $bus['kapasitas'] : ''; ?>" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" placeholder="Jumlah kursi" required>
                            </div>
                        </div>
                    </div>

                    <div>
                        <h3 class="text-lg font-semibold text-slate-700 mb-4">Fasilitas</h3>
                        <div>
                            <label for="fasilitas" class="block text-sm font-medium text-slate-600 mb-1">Sebutkan fasilitas yang tersedia</label>
                             <textarea name="fasilitas" id="fasilitas" rows="5" class="w-full px-4 py-2 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500 transition" placeholder="Gunakan baris baru untuk setiap fasilitas.&#10;Contoh:&#10;- AC&#10;- Toilet&#10;- Reclining Seat&#10;- Bantal & Selimut"><?php echo isset($bus) ? html_escape($bus['fasilitas']) : ''; ?></textarea>
                        </div>
                    </div>

                    <div class="flex justify-end space-x-4 mt-8 pt-6 border-t border-slate-200">
                        <a href="<?php echo site_url('admin/bus'); ?>" class="bg-slate-200 hover:bg-slate-300 text-slate-800 font-bold py-2.5 px-6 rounded-lg transition-colors">
                            Batal
                        </a>
                        <button type="submit" class="bg-cyan-500 hover:bg-cyan-600 text-white font-bold py-2.5 px-6 rounded-lg transition-colors shadow-md hover:shadow-lg">
                            Simpan Bus
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>