<div class="bg-slate-50 min-h-screen">
    <div class="container mx-auto px-6 py-8">
        <div class="flex items-center mb-6">
            <a href="<?php echo site_url('admin/pesanan'); ?>" class="text-slate-500 hover:text-cyan-600 mr-4">
                <i class="fas fa-arrow-left fa-lg"></i>
            </a>
            <h1 class="text-3xl font-bold text-slate-800">
                Detail Pesanan
            </h1>
        </div>
        
        <?php if ($this->session->flashdata('success')): ?>
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded-r-lg" role="alert">
                <p><?php echo $this->session->flashdata('success'); ?></p>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <div class="lg:col-span-2 bg-white shadow-xl rounded-2xl p-8">
                <div class="flex justify-between items-center border-b-2 border-dashed pb-4 mb-4">
                    <div>
                        <h2 class="text-2xl font-bold text-slate-800">E-Tiket BusNusantara</h2>
                        <p class="text-sm text-slate-500">ID Pesanan: <span class="font-mono"><?php echo html_escape($booking['id']); ?></span></p>
                    </div>
                    <img src="<?php echo base_url('assets/img/logo.png'); ?>" alt="Logo" class="h-10">
                </div>
                
                <div class="grid md:grid-cols-2 gap-8">
                    <div>
                        <h3 class="text-sm font-semibold text-slate-400 uppercase mb-2">Penumpang</h3>
                        <p class="text-lg font-bold text-slate-700"><?php echo html_escape($booking['nama']); ?></p>
                        <p class="text-slate-600"><?php echo html_escape($booking['email']); ?></p>
                        <p class="text-slate-600"><?php echo html_escape($booking['telepon']); ?></p>
                    </div>
                     <div>
                        <h3 class="text-sm font-semibold text-slate-400 uppercase mb-2">Armada</h3>
                        <p class="text-lg font-bold text-slate-700"><?php echo html_escape($booking['tipe_bus']); ?></p>
                        <p class="text-slate-600">Kursi No. <span class="font-bold font-mono"><?php echo html_escape($booking['kursi']); ?></span></p>
                    </div>
                </div>

                <div class="border-t border-slate-200 mt-6 pt-6">
                    <h3 class="text-sm font-semibold text-slate-400 uppercase mb-2">Detail Perjalanan</h3>
                     <div class="flex items-center">
                        <div class="text-center">
                            <p class="font-bold text-lg text-slate-700"><?php echo html_escape($booking['jam_berangkat']); ?></p>
                            <p class="text-sm text-slate-500"><?php echo date('d M', strtotime($booking['tanggal_berangkat'])); ?></p>
                        </div>
                        <div class="flex-grow mx-4">
                            <div class="w-full h-px bg-slate-200 relative">
                                <i class="fas fa-bus-alt text-slate-400 absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 bg-white px-2"></i>
                            </div>
                        </div>
                         <div class="text-center">
                            <p class="font-bold text-lg text-slate-700">Tiba</p>
                            <p class="text-sm text-slate-500">Estimasi</p>
                        </div>
                    </div>
                    <div class="flex justify-between mt-1 text-sm">
                        <p class="font-semibold text-slate-700"><?php echo html_escape($booking['rute_asal']); ?></p>
                        <p class="font-semibold text-slate-700"><?php echo html_escape($booking['rute_tujuan']); ?></p>
                    </div>
                </div>
            </div>

            <div class="lg:col-span-1">
                <div class="bg-white shadow-xl rounded-2xl p-6 sticky top-8">
                    <h2 class="text-xl font-semibold border-b pb-3 mb-4">Aksi & Status</h2>
                    <div class="space-y-3 mb-6">
                        <div class="flex justify-between items-center">
                            <span class="text-slate-600">Harga Tiket:</span>
                            <span class="font-bold text-slate-800">Rp <?php echo number_format($booking['harga_rute'], 0, ',', '.'); ?></span>
                        </div>
                        <div class="flex justify-between items-center">
                            <span class="text-slate-600">Status Saat Ini:</span>
                            <?php if ($booking['status_pembayaran'] == 'paid'): ?>
                                <span class="bg-green-100 text-green-800 font-medium text-sm px-3 py-1 rounded-full">Paid</span>
                            <?php elseif ($booking['status_pembayaran'] == 'pending'): ?>
                                <span class="bg-yellow-100 text-yellow-800 font-medium text-sm px-3 py-1 rounded-full">Pending</span>
                            <?php else: ?>
                                <span class="bg-red-100 text-red-800 font-medium text-sm px-3 py-1 rounded-full">Cancelled</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <form id="updateStatusForm" action="<?php echo site_url('admin/pesanan/update_status/' . $booking['id']); ?>" method="post">
                        <label for="status_pembayaran" class="block text-sm font-medium text-gray-700 mb-2">Ubah Status Menjadi:</label>
                        <select name="status_pembayaran" id="status_pembayaran" class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-cyan-500">
                            <option value="pending" <?php if($booking['status_pembayaran'] == 'pending') echo 'selected'; ?>>Pending</option>
                            <option value="paid" <?php if($booking['status_pembayaran'] == 'paid') echo 'selected'; ?>>Paid</option>
                            <option value="cancelled" <?php if($booking['status_pembayaran'] == 'cancelled') echo 'selected'; ?>>Cancelled</option>
                        </select>
                        <button type="submit" class="mt-4 w-full bg-cyan-500 text-white font-bold py-2.5 px-4 rounded-lg hover:bg-cyan-600 transition duration-200">
                            Simpan Perubahan
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="cancelConfirmModal" class="hidden fixed inset-0 bg-gray-900 bg-opacity-60 flex items-center justify-center z-[1000] p-4">
    <div class="bg-white rounded-2xl shadow-xl p-8 text-center max-w-sm w-full transform transition-all duration-300 scale-95 opacity-0" id="cancelModalContent">
        <div class="flex items-center justify-center h-16 w-16 rounded-full bg-red-100 mx-auto mb-4">
            <i class="fas fa-exclamation-triangle fa-2x text-red-600"></i>
        </div>
        <h3 class="text-2xl font-bold mb-2 text-slate-800">Batalkan Pesanan?</h3>
        <p class="mb-6 text-slate-500">Aksi ini tidak dapat diurungkan. Stok kursi akan dikembalikan. Lanjutkan?</p>
        <div class="flex justify-center space-x-4">
            <button id="cancelActionBtn" class="bg-slate-200 hover:bg-slate-300 text-slate-800 font-bold py-2.5 px-6 rounded-lg transition-colors">
                Tidak
            </button>
            <button id="confirmCancelBtn" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2.5 px-6 rounded-lg transition-colors">
                Ya, Batalkan
            </button>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const statusForm = document.getElementById('updateStatusForm');
    const statusSelect = document.getElementById('status_pembayaran');
    const cancelModal = document.getElementById('cancelConfirmModal');
    const cancelModalContent = document.getElementById('cancelModalContent');
    const cancelActionBtn = document.getElementById('cancelActionBtn');
    const confirmCancelBtn = document.getElementById('confirmCancelBtn');

    if (statusForm) {
        statusForm.addEventListener('submit', function(e) {
            // Jika admin memilih untuk membatalkan pesanan
            if (statusSelect.value === 'cancelled') {
                e.preventDefault(); // Hentikan pengiriman form
                
                // Tampilkan modal konfirmasi
                cancelModal.classList.remove('hidden');
                setTimeout(() => {
                    cancelModalContent.classList.remove('scale-95', 'opacity-0');
                    cancelModalContent.classList.add('scale-100', 'opacity-100');
                }, 50);
            }
            // Jika memilih status lain (paid/pending), form akan langsung dikirim
        });
    }

    function closeModal() {
        cancelModalContent.classList.add('scale-95', 'opacity-0');
        setTimeout(() => {
            cancelModal.classList.add('hidden');
        }, 300);
    }

    // Jika tombol "Ya, Batalkan" di modal di-klik, kirim formnya
    if (confirmCancelBtn) {
        confirmCancelBtn.addEventListener('click', function() {
            statusForm.submit();
        });
    }
    
    // Event listener untuk menutup modal
    if (cancelActionBtn) cancelActionBtn.addEventListener('click', closeModal);
    if (cancelModal) {
        cancelModal.addEventListener('click', function(e) {
            if (e.target === cancelModal) {
                closeModal();
            }
        });
    }
});
</script>