<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    // Metode untuk statistik dashboard
    public function get_total_pendapatan()
    {
        $this->db->select('SUM(rb.harga) AS total_pendapatan', FALSE);
        $this->db->from('bookings b');
        $this->db->join('rute_buses rb', 'b.rute_id = rb.id');
        $this->db->where('b.status_pembayaran', 'paid');
        $query = $this->db->get();
        return $query->row()->total_pendapatan ? $query->row()->total_pendapatan : 0;
    }

    public function get_total_tiket_terjual()
    {
        $this->db->where('status_pembayaran', 'paid');
        return $this->db->count_all_results('bookings');
    }

    public function get_total_rute()
    {
        return $this->db->count_all('rute_buses');
    }

    public function get_total_pengguna()
    {
        return $this->db->count_all('users');
    }

    // Metode untuk mengambil aktivitas terbaru
    public function get_recent_activities($limit = 5)
    {
        $this->db->select('id, nama, created_at, status_pembayaran');
        $this->db->order_by('created_at', 'DESC');
        $this->db->limit($limit);
        $query = $this->db->get('bookings');
        
        $activities = [];
        foreach ($query->result_array() as $row) {
            $activity_type = 'pesanan';
            $activity_description = 'Booking baru dari ' . html_escape($row['nama']) . ' (ID: ' . $row['id'] . ')';

            if ($row['status_pembayaran'] === 'paid') {
                $activity_type = 'pembayaran';
                $activity_description = 'Pembayaran diterima untuk booking ID ' . $row['id'] . ' dari ' . html_escape($row['nama']);
            } elseif ($row['status_pembayaran'] === 'cancelled') {
                 $activity_type = 'pembatalan';
                $activity_description = 'Booking ID ' . $row['id'] . ' dibatalkan oleh ' . html_escape($row['nama']);
            }

            $activities[] = [
                'type' => $activity_type, 
                'description' => $activity_description,
                'created_at' => $row['created_at'],
                'timestamp' => $this->time_ago(strtotime($row['created_at']))
            ];
        }
        return $activities;
    }

    // Metode untuk mengambil rute paling populer
    public function get_popular_routes($limit = 5)
    {
        // PERBAIKAN: Ubah COUNT(b.id_rute) menjadi COUNT(b.rute_id)
        $this->db->select('rb.asal, rb.tujuan, COUNT(b.rute_id) as jumlah_pesanan'); // <--- INI PERBAIKANNYA
        $this->db->from('bookings b');
        $this->db->join('rute_buses rb', 'b.rute_id = rb.id');
        $this->db->where('b.status_pembayaran', 'paid');
        $this->db->group_by('rb.id, rb.asal, rb.tujuan');
        $this->db->order_by('jumlah_pesanan', 'DESC');
        $this->db->limit($limit);
        $query = $this->db->get();
        return $query->result_array();
    }

    // Metode umum untuk paginasi data tabel
    public function get_all_data_paginated($table, $limit, $offset, $order_by_col = 'id', $order_by_dir = 'DESC')
    {
        $this->db->limit($limit, $offset);
        $this->db->order_by($order_by_col, $order_by_dir);
        return $this->db->get($table)->result_array();
    }

    // Metode umum untuk menghitung total baris di tabel
    public function count_all_data($table)
    {
        return $this->db->count_all($table);
    }

    // Helper function to format timestamp into human-readable "time ago" string
    private function time_ago($timestamp) {
        $diff = time() - $timestamp;
        if ($diff < 60) {
            return $diff . ' detik lalu';
        } elseif ($diff < 3600) {
            return round($diff / 60) . ' menit lalu';
        } elseif ($diff < 86400) {
            return round($diff / 3600) . ' jam lalu';
        } elseif ($diff < 604800) {
            return round($diff / 86400) . ' hari lalu';
        } else {
            return date('d M Y', $timestamp);
        }
    }

    // Ganti fungsi lama dengan versi baru yang memiliki parameter $searchTerm
    // Ganti fungsi lama dengan versi baru yang menerima array $filters
    public function get_all_bookings_paginated($limit, $offset, $filters = [])
    {
        $this->db->select('
            bookings.id, bookings.nama, bookings.created_at, bookings.status_pembayaran,
            rute_buses.asal as rute_asal, rute_buses.tujuan as rute_tujuan, rute_buses.tanggal_berangkat
        ');
        $this->db->from('bookings');
        $this->db->join('rute_buses', 'rute_buses.id = bookings.rute_id', 'left');

        // Terapkan filter jika ada
        $this->apply_booking_filters($filters);

        $this->db->order_by('bookings.created_at', 'DESC');
        $this->db->limit($limit, $offset);
        return $this->db->get()->result_array();
    }

    public function count_filtered_bookings($filters = [])
    {
        $this->db->from('bookings');
        $this->db->join('rute_buses', 'rute_buses.id = bookings.rute_id', 'left');

        // Terapkan filter jika ada
        $this->apply_booking_filters($filters);

        return $this->db->count_all_results();
    }

    // Fungsi helper baru untuk menerapkan filter, agar tidak duplikat kode
    private function apply_booking_filters($filters)
    {
        if (!empty($filters['search_term'])) {
            $this->db->group_start();
            $this->db->like('bookings.nama', $filters['search_term']);
            $this->db->or_like('rute_buses.asal', $filters['search_term']);
            $this->db->or_like('rute_buses.tujuan', $filters['search_term']);
            $this->db->group_end();
        }
        if (!empty($filters['departure_date'])) {
            $this->db->where('DATE(rute_buses.tanggal_berangkat)', $filters['departure_date']);
        }
        if (!empty($filters['status'])) {
            $this->db->where('bookings.status_pembayaran', $filters['status']);
        }
    }

    public function get_booking_detail($id)
    {
        $this->db->select('
            bookings.*, 
            rute_buses.asal as rute_asal,
            rute_buses.tujuan as rute_tujuan,
            rute_buses.tanggal_berangkat,
            rute_buses.jam_berangkat,
            rute_buses.harga as harga_rute,
            buses.tipe_bus
        ');
        $this->db->from('bookings');
        $this->db->join('rute_buses', 'rute_buses.id = bookings.rute_id');
        $this->db->join('buses', 'buses.id = rute_buses.bus_id');
        $this->db->where('bookings.id', $id);
        return $this->db->get()->row_array();
    }

    public function get_daily_revenue()
    {
        // Query untuk mengambil total pendapatan per hari untuk 7 hari terakhir
        // Hanya menghitung pesanan yang statusnya 'paid'
        $this->db->select('DATE(bookings.created_at) as tanggal, SUM(rute_buses.harga) as total');
        $this->db->from('bookings');
        $this->db->join('rute_buses', 'bookings.rute_id = rute_buses.id');
        $this->db->where('bookings.status_pembayaran', 'paid');
        $this->db->where('bookings.created_at >=', 'DATE_SUB(NOW(), INTERVAL 7 DAY)', FALSE);
        $this->db->group_by('DATE(bookings.created_at)');
        $this->db->order_by('tanggal', 'ASC');
        
        $query = $this->db->get();
        return $query->result_array();
    }
}