<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AdminController extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        // Memuat library yang dibutuhkan
        $this->load->library(['session', 'pagination', 'form_validation']);
        $this->load->helper('url');
        
        // Memuat model utama
        $this->load->model('Admin_model');

        // Proteksi Halaman Admin
        if (!$this->session->userdata('logged_in') || $this->session->userdata('user_role') !== 'admin') {
            $this->session->set_flashdata('error', 'Anda tidak memiliki akses ke halaman ini.');
            redirect('login');
        }
    }

    public function dashboard()
    {
        $data['page_title'] = 'Dashboard Admin';
        $data['stats'] = [
            'total_pendapatan' => $this->Admin_model->get_total_pendapatan(),
            'total_tiket_terjual' => $this->Admin_model->get_total_tiket_terjual(),
            'total_rute' => $this->Admin_model->get_total_rute(),
            'total_pengguna' => $this->Admin_model->get_total_pengguna(),
        ];
        $data['recent_activities'] = $this->Admin_model->get_recent_activities(5);
        $data['popular_routes_admin'] = $this->Admin_model->get_popular_routes(5);

        // --- MULAI PERSIAPAN DATA GRAFIK ---

        // 1. Panggil fungsi model yang baru dibuat
        $daily_revenue_data = $this->Admin_model->get_daily_revenue();
        
        // 2. Siapkan array untuk 7 hari terakhir dengan pendapatan awal 0
        $chart_data = [];
        for ($i = 6; $i >= 0; $i--) {
            $date = date('Y-m-d', strtotime("-$i days"));
            $chart_data[$date] = 0;
        }

        // 3. Isi pendapatan dari database ke array yang sudah disiapkan
        foreach ($daily_revenue_data as $row) {
            $chart_data[$row['tanggal']] = (int)$row['total'];
        }

        // 4. Pisahkan label (tanggal) dan data (pendapatan) untuk Chart.js
        // dan format tanggal menjadi lebih ramah (Contoh: 11 Jul)
        $chart_labels = [];
        foreach (array_keys($chart_data) as $date) {
            $chart_labels[] = date('d M', strtotime($date));
        }

        // 5. Kirim data yang sudah siap ke view dalam format JSON
        $data['chart_labels'] = json_encode($chart_labels);
        $data['chart_data'] = json_encode(array_values($chart_data));
        
        // --- SELESAI PERSIAPAN DATA GRAFIK ---

        $this->load->view('includes/header', $data);
        $this->load->view('admin/dashboard_view', $data);
        $this->load->view('includes/footer', $data);
    }
    
    //=====================================================
    // MANAJEMEN RUTE (DIPERBARUI)
    //=====================================================

    public function rute()
    {
        $data['page_title'] = 'Manajemen Rute';
        
        // Konfigurasi Paginasi (VERSI BARU YANG LEBIH BAIK)
        $config['base_url'] = site_url('admin/rute');
        $config['total_rows'] = $this->Admin_model->count_all_data('rute_buses');
        $config['per_page'] = 10;
        
        // Menerapkan kelas styling ke semua link <a> secara otomatis
        $config['attributes'] = ['class' => 'px-4 py-2 mx-1 rounded-md bg-white text-gray-700 hover:bg-cyan-500 hover:text-white shadow-sm transition-colors duration-200'];

        // Styling untuk wrapper (pembungkus) dan halaman yang sedang aktif
        $config['full_tag_open'] = '<div class="flex items-center justify-center p-4 space-x-1">';
        $config['full_tag_close'] = '</div>';
        $config['cur_tag_open'] = '<span class="px-4 py-2 mx-1 rounded-md bg-cyan-500 text-white font-bold shadow-sm">';
        $config['cur_tag_close'] = '</span>';

        // Menghapus tag individu karena sudah ditangani oleh 'attributes'
        $config['num_tag_open'] = '';
        $config['num_tag_close'] = '';
        $config['next_tag_open'] = '';
        $config['next_tag_close'] = '';
        $config['prev_tag_open'] = '';
        $config['prev_tag_close'] = '';
        $config['first_tag_open'] = '';
        $config['first_tag_close'] = '';
        $config['last_tag_open'] = '';
        $config['last_tag_close'] = '';

        // Teks untuk link
        $config['first_link'] = '&laquo; Awal';
        $config['last_link'] = 'Akhir &raquo;';
        $config['next_link'] = '&rsaquo;';
        $config['prev_link'] = '&lsaquo;';

        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        // Query data (tidak ada perubahan di sini)
        $this->db->select('rute_buses.*, buses.tipe_bus');
        $this->db->from('rute_buses');
        $this->db->join('buses', 'buses.id = rute_buses.bus_id', 'left');
        $this->db->limit($config['per_page'], $page);
        $this->db->order_by('rute_buses.id', 'DESC');
        $data['routes_data'] = $this->db->get()->result_array();
        
        $data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/header', $data);
        $this->load->view('admin/manage_routes_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function tambah_rute()
    {
        $data['page_title'] = 'Tambah Rute Baru';
        // Ambil semua data bus untuk dropdown
        $data['buses'] = $this->db->get('buses')->result_array();
        
        $this->load->view('includes/header', $data);
        $this->load->view('admin/route_form_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function simpan_rute()
    {
        $data_rute = [
            'asal' => $this->input->post('asal'),
            'tujuan' => $this->input->post('tujuan'),
            'tanggal_berangkat' => $this->input->post('tanggal_berangkat'),
            'jam_berangkat' => $this->input->post('jam_berangkat'),
            'bus_id' => $this->input->post('bus_id'),
            'harga' => $this->input->post('harga')
        ];
        $this->db->insert('rute_buses', $data_rute);
        $this->session->set_flashdata('success', 'Rute baru berhasil ditambahkan.');
        redirect('admin/rute');
    }

    public function edit_rute($id)
    {
        $data['page_title'] = 'Edit Rute';
        // Ambil data rute spesifik
        $data['rute'] = $this->db->get_where('rute_buses', ['id' => $id])->row_array();
        // Ambil semua data bus untuk dropdown
        $data['buses'] = $this->db->get('buses')->result_array();
        
        $this->load->view('includes/header', $data);
        $this->load->view('admin/route_form_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function update_rute($id)
    {
        $data_rute = [
            'asal' => $this->input->post('asal'),
            'tujuan' => $this->input->post('tujuan'),
            'tanggal_berangkat' => $this->input->post('tanggal_berangkat'),
            'jam_berangkat' => $this->input->post('jam_berangkat'),
            'bus_id' => $this->input->post('bus_id'),
            'harga' => $this->input->post('harga')
        ];
        $this->db->update('rute_buses', $data_rute, ['id' => $id]);
        $this->session->set_flashdata('success', 'Data rute berhasil diperbarui.');
        redirect('admin/rute');
    }

    public function hapus_rute($id)
    {
        $this->db->delete('rute_buses', ['id' => $id]);
        $this->session->set_flashdata('success', 'Data rute berhasil dihapus.');
        redirect('admin/rute');
    }

    //=====================================================
    // MANAJEMEN BUS (DIPERBARUI)
    //=====================================================

    public function bus()
    {
        $data['page_title'] = 'Manajemen Bus';

        // Konfigurasi Paginasi (VERSI BARU YANG LEBIH BAIK)
        $config['base_url'] = site_url('admin/bus');
        $config['total_rows'] = $this->Admin_model->count_all_data('buses');
        $config['per_page'] = 10;

        // Menerapkan kelas styling ke semua link <a> secara otomatis
        $config['attributes'] = ['class' => 'px-4 py-2 mx-1 rounded-md bg-white text-gray-700 hover:bg-cyan-500 hover:text-white shadow-sm transition-colors duration-200'];

        // Styling untuk wrapper (pembungkus) dan halaman yang sedang aktif
        $config['full_tag_open'] = '<div class="flex items-center justify-center p-4 space-x-1">';
        $config['full_tag_close'] = '</div>';
        $config['cur_tag_open'] = '<span class="px-4 py-2 mx-1 rounded-md bg-cyan-500 text-white font-bold shadow-sm">';
        $config['cur_tag_close'] = '</span>';

        // Menghapus tag individu karena sudah ditangani oleh 'attributes'
        $config['num_tag_open'] = '';
        $config['num_tag_close'] = '';
        $config['next_tag_open'] = '';
        $config['next_tag_close'] = '';
        $config['prev_tag_open'] = '';
        $config['prev_tag_close'] = '';
        $config['first_tag_open'] = '';
        $config['first_tag_close'] = '';
        $config['last_tag_open'] = '';
        $config['last_tag_close'] = '';

        // Teks untuk link
        $config['first_link'] = '&laquo; Awal';
        $config['last_link'] = 'Akhir &raquo;';
        $config['next_link'] = '&rsaquo;';
        $config['prev_link'] = '&lsaquo;';
        
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        $data['buses_data'] = $this->Admin_model->get_all_data_paginated('buses', $config['per_page'], $page);
        $data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/header', $data);
        $this->load->view('admin/manage_buses_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function tambah_bus()
    {
        $data['page_title'] = 'Tambah Bus Baru';
        $this->load->view('includes/header', $data);
        $this->load->view('admin/bus_form_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function simpan_bus()
    {
        // Menyiapkan data sesuai kolom tabel baru
        $data_bus = [
            'tipe_bus' => $this->input->post('tipe_bus'),
            'kapasitas' => $this->input->post('kapasitas'),
            'fasilitas' => $this->input->post('fasilitas')
        ];
        // Pastikan Anda memiliki tabel 'buses' di database
        $this->db->insert('buses', $data_bus);
        $this->session->set_flashdata('success', 'Bus baru berhasil ditambahkan.');
        redirect('admin/bus');
    }

    public function edit_bus($id)
    {
        $data['page_title'] = 'Edit Bus';
        $data['bus'] = $this->db->get_where('buses', ['id' => $id])->row_array();
        $this->load->view('includes/header', $data);
        $this->load->view('admin/bus_form_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function update_bus($id)
    {
        // Menyiapkan data sesuai kolom tabel baru
        $data_bus = [
            'tipe_bus' => $this->input->post('tipe_bus'),
            'kapasitas' => $this->input->post('kapasitas'),
            'fasilitas' => $this->input->post('fasilitas')
        ];
        $this->db->update('buses', $data_bus, ['id' => $id]);
        $this->session->set_flashdata('success', 'Data bus berhasil diperbarui.');
        redirect('admin/bus');
    }

    public function hapus_bus($id)
    {
        $this->db->delete('buses', ['id' => $id]);
        $this->session->set_flashdata('success', 'Data bus berhasil dihapus.');
        redirect('admin/bus');
    }
    
    //=====================================================
    // MANAJEMEN PESANAN
    //=====================================================

    public function pesanan()
{
    $data['page_title'] = 'Manajemen Pesanan';
    $data['has_flatpickr'] = TRUE; // Aktifkan library Flatpickr untuk kalender
    
    // Data awal, tanpa filter
    $filters = [];
    $config['base_url'] = site_url('admin/pesanan');
    $config['total_rows'] = $this->Admin_model->count_filtered_bookings($filters);
    $config['per_page'] = 10;
    // ... (salin konfigurasi styling paginasi yang sudah benar) ...
    $config['attributes'] = ['class' => 'px-4 py-2 mx-1 rounded-md bg-white text-gray-700 hover:bg-cyan-500 hover:text-white shadow-sm transition-colors duration-200'];
    $config['full_tag_open'] = '<div class="flex items-center justify-center p-4 space-x-1">';
    $config['full_tag_close'] = '</div>';
    $config['cur_tag_open'] = '<span class="px-4 py-2 mx-1 rounded-md bg-cyan-500 text-white font-bold shadow-sm">';
    $config['cur_tag_close'] = '</span>';

    $this->pagination->initialize($config);
    $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
    
    $data['bookings_data'] = $this->Admin_model->get_all_bookings_paginated($config['per_page'], $page, $filters);
    $data['pagination'] = $this->pagination->create_links();

    $this->load->view('includes/header', $data);
    $this->load->view('admin/manage_bookings_view', $data);
    $this->load->view('includes/footer', $data);
}

// Ganti fungsi AJAX lama dengan yang ini
public function ajax_search_pesanan()
{
    // Kumpulkan semua data filter dari POST
    $filters = [
        'search_term' => $this->input->post('search_term'),
        'departure_date' => $this->input->post('departure_date'),
        'status' => $this->input->post('status')
    ];
    
    $config['base_url'] = site_url('admin/pesanan');
    $config['total_rows'] = $this->Admin_model->count_filtered_bookings($filters);
    $config['per_page'] = 10;
    // ... (salin lagi konfigurasi styling paginasi di sini) ...
    $config['attributes'] = ['class' => 'px-4 py-2 mx-1 rounded-md bg-white text-gray-700 hover:bg-cyan-500 hover:text-white shadow-sm transition-colors duration-200'];
    $config['full_tag_open'] = '<div class="flex items-center justify-center p-4 space-x-1">';
    $config['full_tag_close'] = '</div>';
    $config['cur_tag_open'] = '<span class="px-4 py-2 mx-1 rounded-md bg-cyan-500 text-white font-bold shadow-sm">';
    $config['cur_tag_close'] = '</span>';

    $this->pagination->initialize($config);
    $page = 0; 
    
    $data['bookings_data'] = $this->Admin_model->get_all_bookings_paginated($config['per_page'], $page, $filters);
    $data['pagination'] = $this->pagination->create_links();

    $table_html = $this->load->view('admin/partials/booking_table_partial', $data, TRUE);
    
    $response = [
        'table_html' => $table_html,
        'pagination_html' => $data['pagination'],
        'new_csrf_hash' => $this->security->get_csrf_hash()
    ];

    $this->output
         ->set_content_type('application/json')
         ->set_output(json_encode($response));
}

    public function detail_pesanan($id)
    {
        $data['page_title'] = 'Detail Pesanan';
        
        // Panggil fungsi baru dari model untuk mendapatkan semua detail
        $data['booking'] = $this->Admin_model->get_booking_detail($id);

        // Jika data tidak ditemukan, tampilkan 404
        if (!$data['booking']) {
            show_404();
        }
        
        $this->load->view('includes/header', $data);
        $this->load->view('admin/booking_detail_view', $data); 
        $this->load->view('includes/footer', $data);
    }

    // Ganti fungsi lama Anda dengan versi lengkap ini
    public function update_status_pesanan($id)
    {
        // Ambil status baru dari form yang dikirim
        $new_status = ['status_pembayaran' => $this->input->post('status_pembayaran')];
        
        // PERBAIKAN: Pastikan baris ini ada dan tidak ada tanda '//' di depannya
        $this->db->update('bookings', $new_status, ['id' => $id]);
        
        // Baris ini sudah benar, biarkan saja
        $this->session->set_flashdata('success', 'Status pesanan berhasil diperbarui.');
        redirect('admin/pesanan/'); // Redirect kembali ke halaman detail
    }

    //=====================================================
    // MANAJEMEN PENGGUNA
    //=====================================================

    public function pengguna()
    {
        $data['page_title'] = 'Manajemen Pengguna';
        $config['base_url'] = site_url('admin/pengguna');
        $config['total_rows'] = $this->Admin_model->count_all_data('users');
        $config['per_page'] = 10;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        $data['users_data'] = $this->Admin_model->get_all_data_paginated('users', $config['per_page'], $page);
        $data['pagination'] = $this->pagination->create_links();

        $this->load->view('includes/header', $data);
        $this->load->view('admin/manage_users_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function edit_pengguna($id)
    {
        $data['page_title'] = 'Edit Pengguna';
        $data['user'] = $this->db->get_where('users', ['id' => $id])->row_array();
        $this->load->view('includes/header', $data);
        $this->load->view('admin/user_form_view', $data);
        $this->load->view('includes/footer', $data);
    }

    public function update_pengguna($id)
    {
        $data_user = [
            'nama' => $this->input->post('nama'),
            'role' => $this->input->post('role'),
        ];
        
        // PERBAIKAN: Pastikan baris ini aktif (tidak ada tanda '//' di depannya)
        $this->db->update('users', $data_user, ['id' => $id]);
        
        $this->session->set_flashdata('success', 'Data pengguna berhasil diperbarui.');
        redirect('admin/pengguna');
    }

    public function hapus_pengguna($id)
    {
        // Pengecekan agar admin tidak bisa menghapus diri sendiri
        if ($id == $this->session->userdata('user_id')) {
            $this->session->set_flashdata('error', 'Anda tidak dapat menghapus akun Anda sendiri.');
            redirect('admin/pengguna');
            return; // Hentikan eksekusi
        }

        // PERBAIKAN: Pastikan baris ini aktif (tidak ada tanda '//' di depannya)
        $this->db->delete('users', ['id' => $id]);
        
        $this->session->set_flashdata('success', 'Data pengguna berhasil dihapus.');
        redirect('admin/pengguna');
    }
}